/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.text;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.contentassist.CommonTextHover;
import com.aptana.editor.common.hover.CustomBrowserInformationControl;
import com.aptana.editor.common.hover.DocumentationBrowserInformationControlInput;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.HTMLModelFormatter;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.text.Messages;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.aptana.ui.epl.UIEplPlugin;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;

public class HTMLTextHover
extends CommonTextHover
implements ITextHover,
ITextHoverExtension2 {
    private static final Map<String, String> TAG_TO_DOC = CollectionsUtil.newMap((Object[])new String[]{"tr", "HTMLTableRowElement", "td", "HTMLTableCellElement", "th", "HTMLTableCellElement", "a", "HTMLLinkElement", "h1", "HTMLHeaderElement", "h2", "HTMLHeaderElement", "h3", "HTMLHeaderElement", "h4", "HTMLHeadingElement", "h5", "HTMLHeaderElement", "h6", "HTMLHeaderElement", "applet", "Applet", "q", "HTMLQuoteElement", "caption", "HTMLTableCaptionElement", "column", "HTMLTableColElement", "col", "HTMLTableColElement", "dl", "HTMLDListElement", "dd", "HTMLDListElement", "dt", "HTMLDListElement", "img", "HTMLImageElement", "ol", "HTMLOListElement", "p", "HTMLParagraphElement", "tbody", "HTMLTableBodyElement", "ul", "HTMLUListElement"});
    private static String activeNodeName;

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IParseNode activeNode = this.getActiveNode(textViewer, hoverRegion.getOffset());
        if (!(activeNode instanceof HTMLElementNode)) {
            return null;
        }
        activeNodeName = activeNode.getNameNode() != null ? activeNode.getNameNode().getName() : "";
        BaseElement element = this.getMatchingElement(textViewer, hoverRegion, (HTMLElementNode)activeNode);
        if (element != null) {
            return this.getHoverInfo(element, this.isBrowserControlAvailable(textViewer), null, (IEditorPart)this.getEditor(textViewer), hoverRegion);
        }
        return null;
    }

    protected BaseElement getMatchingElement(ITextViewer textViewer, IRegion hoverRegion, HTMLElementNode node) {
        IRange elementNameRange = node.getNameNode().getNameRange();
        if (!elementNameRange.contains(hoverRegion.getOffset())) {
            return null;
        }
        try {
            IDocument doc = textViewer.getDocument();
            String openTagContent = doc.get(elementNameRange.getStartingOffset(), elementNameRange.getLength());
            int index = openTagContent.indexOf(node.getName());
            Range tagNameRange = new Range(elementNameRange.getStartingOffset() + index, elementNameRange.getStartingOffset() + index + node.getName().length());
            if (tagNameRange.contains(hoverRegion.getOffset())) {
                return new HTMLIndexQueryHelper().getElement(node.getElementName().toLowerCase());
            }
        }
        catch (BadLocationException doc) {
            // empty catch block
        }
        IParseNodeAttribute attr = node.getAttributeAtOffset(hoverRegion.getOffset());
        if (attr == null) {
            return null;
        }
        IRange nameRange = attr.getNameRange();
        if (nameRange != null && nameRange.contains(hoverRegion.getOffset())) {
            return new HTMLIndexQueryHelper().getAttribute(node.getElementName().toLowerCase(), attr.getName());
        }
        return null;
    }

    public String getHeader(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        if (!(element instanceof BaseElement)) {
            return null;
        }
        return HTMLModelFormatter.TEXT_HOVER.getHeader((BaseElement)element);
    }

    public String getDocumentation(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        if (!(element instanceof BaseElement)) {
            return null;
        }
        return HTMLModelFormatter.TEXT_HOVER.getDocumentation((BaseElement)element);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IParseNode activeNode = this.getActiveNode(textViewer, offset);
        if (!(activeNode instanceof HTMLElementNode)) {
            return null;
        }
        HTMLElementNode node = (HTMLElementNode)activeNode;
        IRange elementNameRange = node.getNameNode().getNameRange();
        if (!elementNameRange.contains(offset)) {
            return null;
        }
        try {
            IDocument doc = textViewer.getDocument();
            String openTagContent = doc.get(elementNameRange.getStartingOffset(), elementNameRange.getLength());
            int start = elementNameRange.getStartingOffset() + openTagContent.indexOf(node.getName());
            Range tagNameRange = new Range(start, start + node.getName().length() - 1);
            if (tagNameRange.contains(offset)) {
                return new Region(tagNameRange.getStartingOffset(), tagNameRange.getLength());
            }
        }
        catch (BadLocationException doc) {
            // empty catch block
        }
        IParseNodeAttribute attr = node.getAttributeAtOffset(offset);
        if (attr == null) {
            return null;
        }
        IRange nameRange = attr.getNameRange();
        if (nameRange != null && nameRange.contains(offset)) {
            return new Region(nameRange.getStartingOffset(), nameRange.getLength());
        }
        return null;
    }

    public void populateToolbarActions(ToolBarManager tbm, CustomBrowserInformationControl iControl) {
    }

    public class OpenDOMReferenceAction
    extends Action {
        private static final String IMG_OPEN_HELP = "icons/full/elcl16/open_browser.gif";
        private static final String IMG_OPEN_HELP_DISABLED = "icons/full/dlcl16/open_browser.gif";
        private CustomBrowserInformationControl iControl;
        private BaseElement node;

        public OpenDOMReferenceAction(CustomBrowserInformationControl iControl) {
            this.setText(Messages.HTMLTextHover_openDomReferenceAction);
            this.setImageDescriptor(UIEplPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)IMG_OPEN_HELP));
            this.setDisabledImageDescriptor(UIEplPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)IMG_OPEN_HELP_DISABLED));
            this.iControl = iControl;
        }

        void update() {
            Object inputElement;
            this.node = null;
            BrowserInformationControlInput input = this.iControl.getInput();
            if (input instanceof DocumentationBrowserInformationControlInput && (inputElement = input.getInputElement()) instanceof BaseElement) {
                this.node = (BaseElement)inputElement;
            }
            this.setEnabled(this.node != null);
        }

        public void run() {
            this.iControl.dispose();
            String name = null;
            String attribute = null;
            if (this.node instanceof AttributeElement) {
                attribute = this.node.getName();
                name = activeNodeName;
            } else {
                name = this.node.getName().toLowerCase();
            }
            name = TAG_TO_DOC.containsKey(name) ? (String)TAG_TO_DOC.get(name) : MessageFormat.format("HTML{0}Element", name);
            String url = attribute != null ? MessageFormat.format("{0}{1}.html?visibility=basic#{1}.{2}", "/com.aptana.documentation/html/reference/api/", name, attribute) : MessageFormat.format("{0}{1}.html", "/com.aptana.documentation/html/reference/api/", name);
            UIUtils.openHelp((String)url);
        }
    }
}

